using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace Win32Utils {

    public class Messages {
        public const int WM_MOUSEWHEEL = 0x020A, WM_MOUSEHWHEEL = 0x20E;
    };

    public class Forms {

        [DllImport("user32", CharSet = CharSet.Auto)]
        private extern static IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wParam, IntPtr lParam);
        
        [DllImport("user32.dll")]
        static extern bool FlashWindow(IntPtr hWnd, bool bInvert);

        public static void FlashForm(Form form) {
            if (form.Handle != IntPtr.Zero) FlashWindow(form.Handle,true);
        }
        
        public static void RelayMessage(Control target, Message msg) {
            SendMessage(target.Handle,msg.Msg,msg.WParam,msg.LParam);
        }
 
       
        [DllImport( "user32.dll", SetLastError=true,  EntryPoint="GetScrollBarInfo")]
        private static extern int GetScrollBarInfo(IntPtr hWnd, uint idObject, ref SCROLLBARINFO psbi);


        [StructLayout(LayoutKind.Sequential)]
        struct SCROLLBARINFO {
            public int cbSize;
            public RECT rcScrollBar;
            public int dxyLineButton;
            public int xyThumbTop;
            public int xyThumbBottom;
            public int reserved;
            public int rgstate0,rgstate1,rgstate2,rgstate3,rgstate4,rgstate5;
        } 

        [StructLayout(LayoutKind.Sequential)]
        struct RECT {
            public int left;
            public int top;
            public int right;
            public int bottom;
        }

        const uint OBJID_CLIENT  = 0xFFFFFFFC;
        const uint OBJID_VSCROLL = 0xFFFFFFFB;
        const uint OBJID_HSCROLL = 0xFFFFFFFA;
        const uint STATE_SYSTEM_UNAVAILABLE = 0x00000001;

        public static bool IsScrollbarEnabled(Control ctrl,bool vertical) {
            if (ctrl.Handle == IntPtr.Zero) return false;
            SCROLLBARINFO sbi = new SCROLLBARINFO();
            sbi.cbSize = Marshal.SizeOf(sbi);
            if (GetScrollBarInfo(ctrl.Handle,vertical ? OBJID_VSCROLL : OBJID_HSCROLL,ref sbi) == 0) return false;
            return (sbi.rgstate0 & STATE_SYSTEM_UNAVAILABLE) == 0;
        }
                
        [DllImport("uxtheme.dll", ExactSpelling=true, CharSet=CharSet.Unicode)]
        public static extern int SetWindowTheme(IntPtr hWnd, String pszSubAppName, String pszSubIdList);    

        public static void SetExplorerTheme(Control ctrl) {
            if (ctrl.Handle != null) SetWindowTheme(ctrl.Handle, "explorer", null);
        }
    }

    public class Shell {
        public static void OpenContainingFolder(string path) {
            //LAME - reimplementme
            System.Diagnostics.Process.Start("explorer.exe","/select,\"" + path + "\"");
        }
    }

}