using System;
using System.Windows.Forms;
using IRCUtils;

namespace monochrome
{
    public partial class UserWindow : IRCWindow, IMessageWindow
    {
        public UserWindow(ServerWindow _owner, string _nick) : base(_owner) {
            m_userHost = "";
            server = _owner; Nick = _nick;
            InitializeComponent();
            UpdateWindowTitle();
            Font = PreferencesManager.Current.Font;

            editBox.ACSource = this.ACSource;

            OnPreferencesChanged(PreferencesManager.Current);

            
        }
        void UpdateWindowTitle() {
            string title = Nick;
            if (UserHost != "") title += " (" + UserHost + ")";
            if (isAway) {
                title += " - Away";
                if (awayMessage != null) title += ": " + awayMessage;
            }
            Text = title;
            userToolStripMenuItem.Text = "User: " + Nick;
        }
        void OnPreferencesChanged(PreferencesData newData) {
            newData.ApplyColors(contentBox);
            newData.ApplyColors(editBox);
            msgSecurityActive = newData.outgoingMsgSecurity;
        }


        protected override ChannelView GetContentBox() {return contentBox;}


        // IMessageWindow

        public override void Flash(int level) {
            if (level == 2 && !OwningServer.Connection.CurrentEventBounced) level = 3;
            base.Flash(level);
        }

        public void HandleDisconnection()
        {

        }

        public void HandleNickChange(string oldNick,string newNick,bool queryClash) {
            if (!queryClash && Nicks.Equals(oldNick,Nick) ) {
                Nick = newNick;
                Text = newNick;
            }
        }

        public void UserHostHint(string nick, string userHost) {
            if (Nicks.Equals(nick,this.Nick)) {
                this.UserHost = userHost;
            }
        }

        public void SetUserAway(string nick, bool state, string reasonOptional) {
            if (Nicks.Equals(nick,this.Nick)) {
                string reason = reasonOptional;
                if (state && reason == null) reason = awayMessage;
                if (state != isAway || reason != awayMessage) {
                    isAway = state; awayMessage = reason;
                    UpdateWindowTitle();
                }
            }
        }

        public void SetLogTarget(object target) {
            m_logTarget = target as string;
            browseLogsToolStripMenuItem.Enabled = (target != null);
        }

        void runUserCommand(string command) {
            server.Connection.runContextCommandAliasable(Nick,command,this);
        }

        void OnDispose() {
            var c = server.Connection;
            if (c != null) c.WindowClosed(Nick,this);
        }



        // IRCWindow
       
        public override void SetDefaultFocus() {
            editBox.Focus();
        }

        string UserHost {
            get {
                return m_userHost;
            }
            set {
                if (m_userHost != value) {
                    m_userHost = value;
                    UpdateWindowTitle();
                }
            }
        }


        string m_userHost;
        ServerWindow server;

        string Nick { // map to IRCWindow.Context
            get { return Context; }
            set { Context = value; }
        }

        bool isAway;
        string awayMessage;
        bool msgSecurityActive;
        string m_logTarget;

        private void whoisToolStripMenuItem_Click(object sender, EventArgs e) {
            OwningServer.Connection.runCommand("/WHOIS " + Nick,this);
        }

        private void sendFileToolStripMenuItem_Click(object sender, EventArgs e) {
            if (editBox_IsInputAllowed()) {
                OwningServer.Connection.runCommand("/SENDFILE " + Nick,this);
            }
        }

        private void editBox_OnEditBoxKeyDown(object sender, KeyEventArgs e) {
            if (!e.Handled) {
                if (OnEditBoxKey(e.KeyCode)) e.Handled = true;
            }
        }

        private bool editBox_OnInput(string[] content) {
            foreach(string line in content) {
                runUserCommand(IRCUtils.Misc.ProcessOutgoing(line));
            }
            return true;
        }

        private void timeToolStripMenuItem_Click(object sender, EventArgs e) {
            OwningServer.Connection.runCTCP(Nick,"TIME","");
        }

        private void clientVersionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OwningServer.Connection.runCTCP(Nick,"VERSION","");
        }

        private void pingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OwningServer.Connection.runPING(Nick);
        }

        private bool editBox_IsInputAllowed()
        {
            if (!contentBox.EnsureBottomVisible()) return false;
            if (msgSecurityActive && !OwningServer.Connection.isUserVisible(this.Nick)) {
                System.Media.SystemSounds.Beep.Play();
                PrintOutputV2( TextLine.Simple( "User is currently offline!" ) );
                return false;
            }
            return true;
        }

        private void browseLogsToolStripMenuItem_Click(object sender, EventArgs e) {
            if (m_logTarget != null) {
                Win32Utils.Shell.OpenContainingFolder(m_logTarget);
            }
        }
    }
}
