using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace monochrome
{
    public partial class TriggerLog : monochrome.SwitchableChildWindow
    {
        public TriggerLog() : this(null,"") {}
        public TriggerLog(MainWindow owner, string label) : base(owner) {
            InitializeComponent();
            Text = label;
            OnPreferencesChanged(PreferencesManager.Current);
        }
//        protected override bool ShowWithoutActivation { get {return true;} }
        void OnPreferencesChanged(PreferencesData newData) {
            Font = newData.Font;
            newData.ApplyColors(contentBox);
        }
        public void AddLine(TextLine line) {
            contentBox.addLine(line);
            Flash(1);
        }
        void OnDispose()
        {
            ownerMainWnd.TriggerLogClosed(this);
        }
    }
}
