using System;
using System.Collections.Generic;
using System.Windows.Forms;
using IRCUtils;

namespace monochrome
{
   
    public partial class ServerWindow : IRCWindow, IMessageWindow, IServerConnectionDelegate
    {
        private ServerConnection m_theConnection;
        private String m_logTarget;

        public ServerConnection Connection {
            get { return m_theConnection; }
        }
        public override string GetButtonText() {
            return Text;
        }
        public override void CloseRequest()
        {
            DialogResult res = MessageBox.Show("Disconnect from \"" + GetButtonText() + "\" ?", "Close", MessageBoxButtons.YesNo, MessageBoxIcon.None);
            if (res == DialogResult.Yes) Close();
        }

        public ServerWindow(MainWindow _owner,ServerParams _params, string netName) : base(_owner)
        {
            var Prefs = PreferencesManager.Current;
            InitializeComponent();
            Text = netName;
            Font = Prefs.Font;
            
            statusToolStripMenuItem.Text = "Status: " + netName;
            ApplyPreferences(Prefs);

            m_theConnection = new ServerConnection( this, this, _params, netName);
            editBox.ACSource = this.ACSource;


            Connection.PreopenChannels();

            Show();
        }
        void OnDispose()
        {
            if (m_theConnection != null) {
                m_theConnection.Dispose();
                m_theConnection = null;
            }
        }

        void ApplyPreferences(PreferencesData newData) {
            newData.ApplyColors(contentBox);
            newData.ApplyColors(editBox);
        }

        void OnPreferencesChanged(PreferencesData newData) {
            ApplyPreferences( newData );
            if ( m_theConnection != null ) m_theConnection.OnPreferencesChanged( newData );
        }


        private void editBox_OnEditBoxKeyDown(object sender, KeyEventArgs e) {
            if (!e.Handled) {
                if (OnEditBoxKey(e.KeyCode)) e.Handled = true;
            }
        }
        private bool editBox_OnInput(string[] content) {
            foreach(string line in content) {
                m_theConnection.runCommandAliasable(Misc.ProcessOutgoing(line),this);
            }
            return true;
        }
        protected override ChannelView GetContentBox() {return contentBox;}


        private void ServerWindow_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_theConnection.WindowClosed();
        }

        public override void SetDefaultFocus() {
            editBox.Focus();
        }


        private bool editBox_IsInputAllowed()
        {
            return contentBox.EnsureBottomVisible();
        }

        private void browseLogsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (m_logTarget != null) {
                Win32Utils.Shell.OpenContainingFolder(m_logTarget);
            }
        }
        public void SetLogTarget(object target) {
            m_logTarget = target as string;
            browseLogsToolStripMenuItem.Enabled = (target != null);
        }

        // IMessageWindow
        public void SetUserAway(string nick, bool state, string reasonOptional)
        {
            
        }
        public void UserHostHint(string nick, string userHost)
        {

        }

        public void HandleDisconnection()
        {

        }
        public void HandleNickChange(string oldNick,string newNick,bool queryClash) {
        }

        
        // IServerConnectionDelegate
        public void OnActivity() {
        }

        public IMessageWindow NewQueryWindow( string forUser )
        {
            return new UserWindow( this, forUser );
        }
        public IChannelWindow NewChannelWindow( string forChannel, ChannelStatus status )
        {
            return new ChannelWindow( this, forChannel, status );
        }
        public bool SwitchToWindowIndex( int index )
        {
            return ownerMainWnd.SwitchToChild( index );
        }
        public void SwitchToWindowDelta( int delta )
        {
            ownerMainWnd.SwitchToChildDelta( delta );
        }
        public void MoveWindowDelta ( IMessageWindow window, int delta )
        {
            ownerMainWnd.MoveChildDelta( (SwitchableChildWindow) window, delta );
        }
        public bool MoveWindowTo( IMessageWindow window, int index )
        {
            return ownerMainWnd.MoveChildToIndex( (SwitchableChildWindow) window, index );
        }
        public bool CanExternalUpdatePreferences()
        {
            return ownerMainWnd.canExternalUpdatePreferences;
        }
        public void ExternalUpdatePreferences( PreferencesData prefs )
        {
            ownerMainWnd.externalUpdatePreferences( prefs );
        }
        public void LogActivity(string context, TextLine line,int level)
        {
            ownerMainWnd.LogActivity( this, context, line, level );
        }

        public void OnManualAway(bool isAway) {
            ownerMainWnd.OnManualAway( isAway );
        }
        public void OpenFileForDCCSend(Action<object, string> callMe, IMessageWindow contextWindow) {
            using(OpenFileDialog of = new OpenFileDialog()) {
                if (of.ShowDialog(this) == DialogResult.OK) {
                    try {
                        string filePath = of.FileName;
                        string fileName = System.IO.Path.GetFileName(filePath);
                        callMe( filePath, fileName );
                    } catch(Exception e) {
                        contextWindow.PrintOutputV2( TextLine.Simple("Could not initiate DCC SEND: " + e.Message) );
                    }
                }
            }
        }

        public void BeginDCCSend( object pathObj, DCCDescription desc )
        {
            string filePath = (string) pathObj;
            UInt64 fileSize;
            using(System.IO.FileStream file = System.IO.File.OpenRead(filePath)) {
                fileSize = (UInt64)file.Length;
            }
            new DCCSendWindow( this, desc, filePath, fileSize );
        }
 
        public void BeginDCCReceive( DCCDescription desc, UInt64 _fileSize,PreferencesData _prefs,bool _autoAcceptTrigger)
        {
            new DCCReceiveWindow( this, desc, _fileSize, _prefs, _autoAcceptTrigger );
        }
       
    }

}