using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace monochrome
{
    public partial class ResizableContainer : ContainerControl
    {
        public ResizableContainer()
        {
            dragBorder = Border.None;
            InitializeComponent();
        }

        private void ResizableContainer_MouseCaptureChanged(object sender, EventArgs e) {
            dragBorder = Border.None;
        }

        private void ResizableContainer_MouseDown(object sender, MouseEventArgs e) {
            if (e.Button == MouseButtons.Left) {
                Border border = BorderFromPoint(e.Location);
                if (BorderDraggable(border)) {
                    dragBorder = border;
                    Capture = true;
                    lastDrag = e.Location;
                }
            }
        }

        Border BorderFromPoint(Point pt) {
            if (pt.X < Padding.Horizontal) return Border.Left;
            else if (pt.X > Width - Padding.Horizontal) return Border.Right;
            else if (pt.Y < Padding.Vertical) return Border.Top;
            else if (pt.Y > Height - Padding.Vertical) return Border.Bottom;
            else return Border.None;
        }

        bool BorderDraggable(Border border) {
            switch(border) {
                case Border.Left:
                    return Dock == DockStyle.None || Dock == DockStyle.Right;
                case Border.Right:
                    return Dock == DockStyle.None || Dock == DockStyle.Left;
                case Border.Top:
                    return Dock == DockStyle.None || Dock == DockStyle.Bottom;
                case Border.Bottom:
                    return Dock == DockStyle.None || Dock == DockStyle.Top;
                default:
                    return false;
            }
        }

        enum Border {
            None, Left, Right, Top, Bottom
        }

        private void ResizableContainer_MouseMove(object sender, MouseEventArgs e) {
            switch(BorderFromPoint(e.Location)) {
                case Border.Left:
                case Border.Right:
                    Cursor = Cursors.SizeWE;
                    break;
                case Border.Top:
                case Border.Bottom:
                    Cursor = Cursors.SizeNS;
                    break;
                default:
                    Cursor = Cursors.Default;
                    break;
            }
            if (Capture && e.Location != lastDrag) {
                switch(dragBorder) {
                    case Border.Left:
                        if (e.Location.X < Width) {
                            Width = Width - e.Location.X;
                            if (Dock != DockStyle.Right) Left = e.Location.X;
                            ParentForm.Update();
                        }
                        break;
                    case Border.Right:
                        if (e.Location.X > 0) {
                            Width = e.Location.X;
                            ParentForm.Update();
                        }
                        break;
                    case Border.Top:
                        if (e.Location.Y < Height) {
                            Height = Height - e.Location.Y;
                            if (Dock != DockStyle.Bottom) Top = e.Location.Y;
                            ParentForm.Update();
                        }
                        break;
                    case Border.Bottom:
                        if (e.Location.Y > 0) {
                            Height = e.Location.Y;
                            ParentForm.Update();
                        }
                        break;
                }
                lastDrag = e.Location;
            }
        }

        private void ResizableContainer_MouseUp(object sender, MouseEventArgs e)
        {
            Capture = false;
        }
    
        Border dragBorder;
        Point lastDrag;

        private void ResizableContainer_MouseLeave(object sender, EventArgs e)
        {
            this.Cursor = Cursors.Default;
        }
    }
}
