﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace monochrome {
    public partial struct PreferencesData {

        public Color ColorBackground {
            get { return colorBackground.IsEmpty ? SystemColors.Window : colorBackground.PlatformColor; }
        }
        public Color ColorText {
            get { return colorText.IsEmpty ? SystemColors.WindowText : colorText.PlatformColor; }
        }
        public Color AutoHighlightColor {
            get {
                return (SystemColors.WindowText.GetBrightness() < 0.5) ? Color.DarkBlue : Color.AliceBlue;
            }
        }
        public Color ColorHighlight {
            get { return colorHighlight.IsEmpty ? AutoHighlightColor : colorHighlight.PlatformColor; }
        }
        public Color ColorChanHighlight1 {
            get { return colorChanHighlight1.IsEmpty ? Color.Blue : colorChanHighlight1.PlatformColor; }
        }
        public Color ColorChanHighlight2 {
            get { return colorChanHighlight2.IsEmpty ? Color.Red : colorChanHighlight2.PlatformColor; }
        }
        public Color ColorChanHighlight3 {
            get { return colorChanHighlight3.IsEmpty ? Color.OrangeRed : colorChanHighlight3.PlatformColor; }
        }
        public Color ColorUserJoin {
            get { return colorUserJoin.IsEmpty ? SystemColors.GrayText : colorUserJoin.PlatformColor; }
        }
        public Color ColorUserPart {
            get { return colorUserPart.IsEmpty ? SystemColors.GrayText : colorUserPart.PlatformColor; }
        }
    }
}
