﻿using System;
using System.Windows.Forms;
using System.Threading;
using System.Drawing;

namespace monochrome
{

    class Debug
    {
        public static void WriteLine( string line )
        {
            Console.WriteLine( line );
        }
    }

    public partial struct ColorDesc {
        public static ColorDesc FromPlatformColor(Color c) {
            var d = new ColorDesc();
            d.PlatformColor = c;
            return d;
        }
        public Color PlatformColor {
            get {
                return Color.FromArgb(AsInt);
            }
            set {
                AsInt = value.ToArgb();
            }
        }
    }

    class PlatformMethods {
        public static byte[] StringMD5( string str ) {
            using (System.Security.Cryptography.MD5 md5 = System.Security.Cryptography.MD5.Create()) {
                return md5.ComputeHash( System.Text.Encoding.UTF8.GetBytes(str));
            }
        }
    }
}