﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace monochrome
{
    class Logging {

        static SemaphoreSlim loggingTrigger = new SemaphoreSlim(0);
        static LinkedList<Action> loggingActions = new LinkedList<Action>();

        static bool loggingLoopRunning = false;

        static async void loggingLoop() {
            for (;;) {
                await loggingTrigger.WaitAsync();
                var action = loggingActions.First.Value;
                loggingActions.RemoveFirst();

                try {
                    await Task.Run(action);
                } catch {}
                
            }
        }

        // returns path of used log file
        public static void WriteLine(string server, string context, string line, Action<object> returnLogTarget ) {
            PreferencesData prefs = PreferencesManager.Current;

            if (prefs.useLogging) {

                if (!loggingLoopRunning) {
                    loggingLoopRunning = true;
                    loggingLoop();
                }

                DateTime time = DateTime.Now;
                string dirpath = Path.Combine(prefs.loggingPath, server);
                string filename = ((context == null) ? "[server]" : context);
                if (prefs.splitLogsByDays) filename += ", " + time.ToString("yyyy-MM-dd");
                filename += ".txt";
                {
                    char[] invalid = Path.GetInvalidFileNameChars();
                    for (int walk = 0; ;) {
                        int index = filename.IndexOfAny(invalid, walk);
                        if (index < 0) break;
                        filename = filename.Substring(0, index) + '_' + filename.Substring(index + 1);
                        walk = index + 1;
                    }
                }

                string logFilePath = Path.Combine(dirpath, filename);
                if ( returnLogTarget != null ) returnLogTarget( logFilePath );
                string toAppend = time.ToString(prefs.loggingTimestampFormat) + " " + line + "\r\n";

                loggingActions.AddLast(() => {
                    try { Directory.CreateDirectory(dirpath); } catch { }
                    try { File.AppendAllText(logFilePath, toAppend, System.Text.Encoding.UTF8); } catch { }
                });
                loggingTrigger.Release();
            }
        }
    }
}
