using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using IRCUtils;

namespace monochrome
{
    public partial class InputBox : TextBox
    {
        public InputBox()
        {
            InitializeComponent();
            m_acHandler = new AutoCompleteHandlerWinForms(null,this);
            m_backLog = new LineHistory();
        }

        private void textBox_KeyDown(object sender, KeyEventArgs e) {
            if (!e.Handled) {
                if (OnEditBoxKeyDown != null) {
                    OnEditBoxKeyDown(this,e);
                }
            }
            if (!e.Handled) {
                switch(e.KeyCode) {
                    case Keys.Up:
                        if (ModifierKeys == Keys.Control) {
                            string val = m_backLog.Previous();
                            if (val != null) {
                                this.Text = val;
                                this.SelectionStart = val.Length;
                            }
                            e.Handled = true;
                        }
                        
                        break;
                    case Keys.Down:
                        if (ModifierKeys == Keys.Control) {
                            string val = m_backLog.Next();
                            if (val != null) {
                                this.Text = val;
                                this.SelectionStart = 0;
                            }
                            e.Handled = true;
                        }
                        break;
                }
            }
        }

        private bool _isInputAllowed() {
            if (IsInputAllowed == null) return true;
            return IsInputAllowed();
        }

        private void textBox_KeyPress(object sender, KeyPressEventArgs e) {
            if (!e.Handled) {
                switch(e.KeyChar) {
                    case '\r':
                        if (_isInputAllowed()) {
                            m_acHandler.Reset();
                            string[] lines = this.Text.Split(new char[]{'\r','\n'},StringSplitOptions.RemoveEmptyEntries);
                            if (sendInput(lines)) {
                                foreach(string line in lines) m_backLog.Add(line);
                                this.Text = "";
                            }
                        }
                        e.Handled = true;
                        break;
                }
            }
        }
        private bool sendInput(string[] input) {
            if (OnInput == null) return false;
            if (!BSFilter.Test(input)) return false;
            return OnInput(input);
        }

        public delegate bool OnInputFunc(string[] content);
        public delegate bool IsInputAllowedFunc();
        public event OnInputFunc OnInput;
        public event KeyEventHandler OnEditBoxKeyDown;
        public event IsInputAllowedFunc IsInputAllowed;
        

        
        public IAutoCompleteSource ACSource {
            set {
                m_acHandler.Reset(value);
            }
        }

        AutoCompleteHandler m_acHandler;
        LineHistory m_backLog;



        bool VertScrollable {
            get {
                return Win32Utils.Forms.IsScrollbarEnabled(this,true);
                //return this.Lines.Length > 1;
            }
        }

        protected override void WndProc(ref Message m) {
            switch(m.Msg) {
                default:
                    base.WndProc(ref m);
                    break;
                case Win32Utils.Messages.WM_MOUSEHWHEEL:
                case Win32Utils.Messages.WM_MOUSEWHEEL:
                    if (!VertScrollable) {
                        Win32Utils.Forms.RelayMessage(Parent,m);
                    } else {
                        base.WndProc(ref m);
                    }
                    break;
            }
        }
    }
}
