using System;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.IO;
using System.Text;

namespace monochrome {
    class IdentServer {

        public IdentServer(string userName,IPAddress listenAddress) {
            m_shutdown = false;
            m_userName = userName;
            m_lastRequest = DateTime.UtcNow;
            m_listenAddress = listenAddress;
            (new Thread(new ThreadStart(listenProcV2))).Start();
        }
        public void RequestShutdown() {
            lock(this) m_shutdown = true;
        }

        public bool Bump() {
            lock(this) {
                if (m_shutdown) return false;
                m_lastRequest = DateTime.UtcNow;
                return true;
            }
        }

        bool QuitSwitch() {
            lock(this) {
                if (m_shutdown) {
                    return true;
                } else if (DateTime.UtcNow - m_lastRequest > TimeSpan.FromMinutes(1)) {
                    m_shutdown = true;
                    return true;
                } else {
                    return false;
                }
            }
        }

        void identProcV2(object _client) {
            try {
                Encoding textEncoding = Encoding.ASCII;
                using(TcpClient client = (TcpClient) _client) {
                    using(Stream stream = client.GetStream()) {
                        string input;
                        using(TextReader reader = new StreamReader(stream,textEncoding))
                        using(TextWriter writer = new StreamWriter(stream,textEncoding)) {
                            input = reader.ReadLine();
                            string reply = /*"ERROR : NO-USER"*/ "USERID : UNIX : " + m_userName;
                            writer.WriteLine( input + " : " + reply );
                        }
                    }
                }
            } catch(Exception e) {
                Debug.WriteLine("Ident failure: " + e.Message);
            }
        }

        void listenProcV2() {
            Debug.WriteLine("Initializing ident listener...");
            try {
                TcpListener listener = new TcpListener(m_listenAddress, 113);
                try {
                    listener.Start(13);
                    while(!QuitSwitch()) {
                        
                        if (listener.Server.Poll(10 * 1000,SelectMode.SelectRead)) {
                            Debug.WriteLine("Accepting ident request...");
                            TcpClient client = listener.AcceptTcpClient();
                            try {
                                new Thread(new ParameterizedThreadStart(identProcV2)).Start(client);
                            } catch {
                                client.Close();
                                throw;
                            }
                        }
                    }
                } finally {
                    listener.Stop();
                }
            } catch(Exception e) {
                Debug.WriteLine("Ident listener failure: " + e.Message);
            }
            Debug.WriteLine("Ident listener shut down.");
        }


        bool m_shutdown;
        string m_userName;
        DateTime m_lastRequest;
        IPAddress m_listenAddress;
    }

    class IdentManager {
        IdentManager(IPAddress listenAddress) { m_listenAddress = listenAddress; }

        void bump(string name) {
            lock(this) {
                if (server != null) {
                    if (!server.Bump()) server = null;
                }
                if (server == null) server = new IdentServer(name,m_listenAddress);
            }
        }
        void shutdown() {
            lock(this) {
                if (server != null) server.RequestShutdown();
            }
        }
        static IdentManager ResolveFamily(AddressFamily family) {
            switch(family) {
                case AddressFamily.InterNetworkV6:
                    return InstanceV6;
                case AddressFamily.InterNetwork:
                default:
                    return Instance;
            }
        }
        public static void Bump(string name) {
            Instance.bump(name);
            InstanceV6.bump(name);
        }
        public static void Shutdown() {
            Instance.shutdown();
            InstanceV6.shutdown();
        }

        static IdentManager Instance = new IdentManager( IPAddress.Any );
        static IdentManager InstanceV6 = new IdentManager( IPAddress.IPv6Any );

        IdentServer server;
        IPAddress m_listenAddress;
    }
}
