﻿using System;
using IRCUtils;

namespace monochrome
{
    public class DCCWindowBase : SwitchableChildWindow {
        protected DCCWindowBase() : this(null,new DCCDescription()) {}
        protected DCCWindowBase(ServerWindow owningServer,DCCDescription desc) : base( owningServer != null ? owningServer.ownerMainWnd : null) {
            m_owningServer = owningServer;
            m_desc = desc;
        }

        protected override void Dispose(bool disposing) {
            if (disposing) {
                m_isClosed = true;
            }
            base.Dispose(disposing);
        }

        
        public DCCDescription Description { get { return m_desc;} }

        protected void OverrideDescription(DCCDescription desc) {
            m_desc = desc;
        }

        public ServerWindow OwningServer { get { return m_owningServer;} } 

        protected void SetTitlePecentage_NoXfer() {SetTitlePercentage(UInt32.MaxValue);}

        protected void SetTitlePercentage(UInt32 percentage) {
            if (m_isClosed) return;
            string label = Text;
            string labelBefore = label;
            int cut = label.IndexOf(':');
            if (cut >= 0) label = label.Substring(0,cut).TrimEnd(' ');
            if (percentage != UInt32.MaxValue) {
                label += " : " + percentage + "%";
            }
            //don't fire text change notifications if it hasn't changed
            if (label != labelBefore) Text = label;
            
        }
        
        DCCDescription m_desc;
        ServerWindow m_owningServer;
        bool m_isClosed;
    }

}