using System;
using System.IO;
using System.Threading.Tasks;

namespace monochrome
{
    sealed class FileReaderImpl : IDCCFileReader {
        public FileReaderImpl( FileStream stream ) {
            m_stream = stream;
        }
        async Task IDCCFileReader.Seek(ulong position) {
            await Task.Run( () => {
                m_stream.Seek((long) position, SeekOrigin.Begin);
            });
        }
        async Task<uint> IDCCFileReader.Read(byte[] buffer) {
            return (uint) await m_stream.ReadAsync(buffer, 0, buffer.Length);
        }
        void IDisposable.Dispose() {
            m_stream.Dispose();
        }
        private FileStream m_stream;
    }
    public partial class DCCSendWindow : DCCWindowBase, IDCCSendDelegate
    {
        public string StatusText
        {
            get { return statusBox.Text; }
            set { statusBox.Text = value; }
        }
        public string MainText
        {
            get { return Text; }
            set { Text = value; }
        }

        public async Task<IDCCFileReader> OpenFile() {
            return await Task.Run( () => {
                var stream = File.OpenRead(m_filePath);
                return new FileReaderImpl( stream );
            });
        }

        public void OnFinished( Exception e )
        {
            if (m_closed) return;
            Running = false;
            Flash(3);
        }

        public void SetProgress( UInt64 bytesDone )
        {
            if ( bytesDone > m_fileSize ) bytesDone = m_fileSize;
            progressBar.Value = Math.Min( progressBar.Maximum, (int) ( (UInt64)progressBar.Maximum * bytesDone / m_fileSize ) );
        }
        public void SetPercentDone( UInt32 pcDone )
        {
            SetTitlePercentage( pcDone );
        }

        public void ToggleRunning(bool bRunning) {
            this.Running = bRunning;
        }


        public DCCSend Sender
        {
            get {  return m_send; }
        }

        public DCCSendWindow(ServerWindow owningServer, DCCDescription desc, string filePath,UInt64 fileSize) : base(owningServer,desc)
        {
            m_filePath = filePath; m_fileSize = fileSize;
            InitializeComponent();
            string fileName = System.IO.Path.GetFileName(m_filePath);
            labelFileName.Text = fileName;
            labelFileSize.Text = fileSize.ToString() + " bytes";
            labelNick.Text = desc.Nick;

            m_send = new DCCSend( owningServer.Connection, desc, this, fileSize );
        }
        

        void OnDispose() {
            m_closed = true;
            m_send.Dispose();
        }

        private void buttonCancel_Click(object sender, EventArgs e) {
            Close();
        }

        private void buttonResend_Click(object sender, EventArgs e) {
            if (Running) {
                /*m_resendRequested = true;
                lock(m_abort) m_abort.Abort();*/
            } else {
                m_send.Resend();
            }
        }

        public bool Running {
            get { return m_running; }
            set { 
                m_running = value; 
                if (!m_closed) {
                    buttonResend.Enabled = !value;
                    buttonCancel.Text = value ? "Cancel" : "Close";
                }
            }
        }

        string m_filePath;
        UInt64 m_fileSize;
        bool m_running, m_closed;
        DCCSend m_send;
    }
}
