using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace monochrome
{
    public partial class ConnectionExistsDialog : SwitchableChildWindow
    {
        public ConnectionExistsDialog(MainWindow owner,string netName,ServerParams svParams) : base(owner)
        {
            m_params = svParams;
            m_netName = netName;
            InitializeComponent();
            label1.Text = "You are already connected to \"" + m_netName + "\".";
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Close();
            (new ServerWindow(ownerMainWnd,m_params,m_netName)).SwitchTo();
            
        }

        private void button3_Click(object sender, EventArgs e)
        {
            ownerMainWnd.CloseExistingConnections(m_netName);
            Close();
            (new ServerWindow(ownerMainWnd,m_params,m_netName)).SwitchTo();
        }

        string m_netName;
        ServerParams m_params;
    }
}