using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using IRCUtils;

namespace monochrome
{
    public partial class BanListWindow : monochrome.SwitchableChildWindow {
        
        public BanListWindow(ChannelWindow owner,char listType) : base(owner.ownerMainWnd, owner) {
            m_listType = listType;
            Channel = owner;
            InitializeComponent();
            string label;
            switch(ListType) {
                case 'b':
                    label = "Ban List";
                    break;
                case 'e':
                    label = "Ban Exemption List";
                    break;
                case 'I':
                    label = "Invite List";
                    break;
                case 'q':
                    label = "Quiet List";
                    break;
                default:
                    label = "???? List";
                    break;
            }
            ButtonText = label;
            Text = label + ": " + owner.ChannelName;
        }
        
        public void SetData( IEnumerable<BanDescription> entries) {
            contentList.Items.Clear();
            foreach(BanDescription entry in entries) AddEntry(entry);
        }

        void AddEntry(BanDescription entry) {
            ListViewItem item = new ListViewItem(new string[]{entry.Mask, entry.Added});
            item.Name = entry.Mask;
            contentList.Items.Add( item );
        }

        public void OnEntryAdded(BanDescription entry) {AddEntry(entry);}

        public void OnEntryRemoved(string entry) {
            contentList.Items.RemoveByKey(entry);
        }

        private void removeEntryToolStripMenuItem_Click(object sender, EventArgs e) {
            LinkedList<string> toAxe = new LinkedList<string>();
            foreach(ListViewItem item in contentList.SelectedItems) toAxe.AddLast(item.Name);
            if (toAxe.Count > 0) Channel.RemoveListEntries(ListType,toAxe);
        }

        void OnDispose()
        {
            Channel.ListWindowClosed(this);
        }

        public char ListType { get { return m_listType; } }
        
        private void contentList_ItemSelectionChanged(object sender, ListViewItemSelectionChangedEventArgs e) {
            removeEntryToolStripMenuItem.Enabled = contentList.SelectedItems.Count > 0;
            removeEntryToolStripMenuItem.Text = contentList.SelectedItems.Count > 1 ? "Remove Entries" : "Remove Entry";
        }

        public override string GetButtonText() {
            return ButtonText;
        }

        string ButtonText;
        char m_listType;
        ChannelWindow Channel;
    }
}
