﻿using System;
using System.Windows.Forms;

namespace monochrome
{
    class ACEditBox : IAutoCompleteEditBox {
        public ACEditBox(TextBox _editBox) {
            m_editBox = _editBox;
        }
        int IAutoCompleteEditBox.GetSelectionEnd() {
            return m_editBox.SelectionStart + m_editBox.SelectionLength;
        }
        string IAutoCompleteEditBox.GetText() {
            return m_editBox.Text;
        }
        void IAutoCompleteEditBox.SetText(string newText, int newSelOffset) {
            m_editBox.Text = newText;
            m_editBox.SelectionLength = 0;
            m_editBox.SelectionStart = newSelOffset;
        }

        TextBox m_editBox;
    }
    public class AutoCompleteHandlerWinForms : AutoCompleteHandler {
        public AutoCompleteHandlerWinForms(IAutoCompleteSource source,System.Windows.Forms.TextBox _editBox) : base(source, new ACEditBox(_editBox)) {
            editBox = _editBox; Reset();
            editBox.Enter += new EventHandler(editBox_EnterLeave);
            editBox.Leave += new EventHandler(editBox_EnterLeave);
            editBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(editBox_KeyPress);
            editBox.TextChanged += new EventHandler(editBox_TextChanged);
        }

        private void editBox_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e) {
            if (!e.Handled && e.KeyChar == '\t') {
                OnTriggerAutoComplete((System.Windows.Forms.Control.ModifierKeys & System.Windows.Forms.Keys.Shift) != 0);
                e.Handled = true;
            }
        }

        private void editBox_TextChanged(object sender, EventArgs e) {
            OnTextChanging();
        }
        private void editBox_EnterLeave(object sender, EventArgs e) {
            OnEnterLeave();
        }

        static bool isSpacing(char c) {
            switch(c) {
                case ' ':
                case ',':
                case '.':
                case ';':
                case ':':
                    return true;
                default:
                    return false;
            }
        }

        TextBox editBox;
    };
}
