using System;
using System.Xml;
using System.Collections.Generic;
using System.Collections;

namespace monochrome
{

    class ArrayHelper {
        public static T[] Arrayify<T>(ICollection<T> col) {
            T[] array = new T[col.Count];
            int walk = 0;
            foreach(T item in col) {
                array[walk++] = item;
            }
            return array;
        }
        public static string MakeListString(IEnumerable source, string separator, string emptyval) {
            bool first = true;
            string list = "";
            foreach(object obj in source) {
                if (first) first = false; else list += separator;
                list += obj.ToString();
            }
            return first ? emptyval : list;
        }
        public static string MakeListString(IEnumerable source) {return MakeListString(source,", ","");}

    }

    class XmlHelper {
        public static void WriteStructField(XmlNode node, string name, string value) {
            XmlDocument document = node.OwnerDocument;
            XmlElement elem = document.CreateElement("entry");
            XmlAttribute attrib = document.CreateAttribute("name");
            attrib.Value = XmlConvert.EncodeName(name);
            elem.Attributes.Append(attrib);
            attrib = document.CreateAttribute("value");
            attrib.Value = value;
            elem.Attributes.Append(attrib);
            node.AppendChild(elem);
        }

        public static string ReadStructField(XmlNode node, string name) {
            foreach ( XmlNode sub in node.ChildNodes ) {
                if ( sub.Name == "entry" ) {
                    XmlAttribute attrib = sub.Attributes.GetNamedItem("name") as XmlAttribute;
                    if ( attrib == null ) continue;
                    if ( attrib.Value != name ) continue;
                    attrib = sub.Attributes.GetNamedItem("value") as XmlAttribute;
                    if ( attrib == null ) return null;
                    return attrib.Value;
                }
            }
            return null;
            /*
            XmlNode _node = node.SelectSingleNode("child::entry[attribute::name=\"" + XmlConvert.EncodeName(name) + "\"]");
            if (_node == null) return null;
            XmlAttribute attrib = _node.Attributes.GetNamedItem("value") as XmlAttribute;
            if (attrib == null) return null;
            return attrib.Value;
            */
        }

        public static void WipeStruct(XmlNode node) {
            var removeMe = new LinkedList<XmlNode>();
            foreach( XmlNode sub in node.ChildNodes ) {
                if ( sub.Name == "entry" ) {
                    removeMe.AddLast( sub );
                }
            }
            foreach (XmlNode sub in removeMe ) node.RemoveChild ( sub );
            // foreach(XmlNode axeme in node.SelectNodes("entry")) node.RemoveChild(axeme);
        }
    }

    public class FloodControl {
        public FloodControl() {
            backlog = new LinkedList<DateTime>();
        }
        public void OnLineSent() {
            backlog.AddLast(DateTime.UtcNow);
        }

        public bool RequestSend() {
            DateTime time = DateTime.UtcNow;
            TimeSpan cutoff = TimeSpan.FromSeconds(2);
            int triggerEvents = 3;
            while(backlog.Count > 0) {
                if (time - backlog.First.Value > cutoff) {
                    backlog.RemoveFirst();
                } else {
                    break;
                }
            }

            if (backlog.Count >= triggerEvents) triggered = true;
            else if (backlog.Count == 0) triggered = false;

            if (canSend(time)) {
                backlog.AddLast(time);
                return true;
            } else {
                return false;
            }
        }
        bool canSend(DateTime time) {
            if (!triggered) return true;
            if (backlog.Count == 0) return true;//sanity check, should not get here
            return time - backlog.Last.Value >= TimeSpan.FromSeconds(1.5);
        }

        public void Reset() {
            backlog.Clear();
        }

        bool triggered;
        LinkedList<DateTime> backlog;
    }
}
