﻿using System;

namespace monochrome {


    class Lingustics {
        public static StringComparer WordComparer { get { return StringComparer.OrdinalIgnoreCase; } }
        public static bool WordPresent(string[] words,string word) {
            StringComparer comparer = WordComparer;
            foreach(string walk in words) {
                if (comparer.Equals(walk,word)) return true;
            }
            return false;
        }
        static bool __WordSequencePresent_Match(string[] words,string[] sequence, int wordsBase) {
            StringComparer comparer = WordComparer;
            for(int walk = 0; walk < sequence.Length; ++walk) {
                if (!comparer.Equals(words[wordsBase+walk],sequence[walk])) return false;
            }
            return true;
        }
        public static bool WordSequencePresent(string[] words,string[] sequence) {
            for(int walk = 0; walk <= words.Length - sequence.Length; ++walk) {
                if (__WordSequencePresent_Match(words,sequence,walk)) return true;
            }
            return false;
        }
        public static bool WordsPresent(string[] words, string[] list) {
            foreach(string walk in list) {
                if (!WordPresent(words,walk)) return false;
            }
            return true;
        }

        public static bool WordsPresentAny(string[] words, string[] list) {
            foreach(string walk in list) {
                if (WordPresent(words,walk)) return true;
            }
            return false;
        }

        public static string[] StringToWords(string msg) {
            return msg.Split(new char[]{' ','.',',',';'},StringSplitOptions.RemoveEmptyEntries);
        }

        
        public static bool IsMsgPasswordIncorrect(string msg) {
            string[] words = StringToWords(msg);
            return WordPresent(words,"password") && WordPresent(words,"incorrect");
        }
        public static bool IsMsgNickNotRegistered(string msg) {
            string[] words = StringToWords(msg);
            return (WordPresent(words,"nick") || WordPresent(words,"nickname")) && WordSequencePresent(words,new string[]{"not","registered"});
        }
        public static bool IsMsgPasswordAccepted(string msg) {
            string[] words = StringToWords(msg);
            return WordPresent(words,"password") && WordPresent(words,"accepted");
        }
        public static bool WordSequencePresent(string[] words, string sequence) {
            return WordSequencePresent(words, StringToWords(sequence));
        }
        public static bool WordSequencePresent(string msg, string sequence) {
            string[] words = StringToWords(msg);
            return WordSequencePresent(words, sequence);
        }

        public static bool IsMsgSuccessfullyIdentified(string msg) {
            string[] words = StringToWords(msg);
            if (WordSequencePresent(words,"successfully identified")) return true;
            if (WordSequencePresent(words,"password accepted")) return true;
            if (WordSequencePresent(words,"now logged in")) return true;
            if (WordSequencePresent(words,"now identified")) return true;
            return false;
        }
        
    }
}
