﻿using System;

namespace monochrome
{
    public class Globals
    {
        public const string Version = "1.4.4";
        public const string VersionSuffix = "";
        public const string VersionCodename = "Liberation";
        public const string Copyright = "(C) 2007-2023 Peter Pawlowski";

        public static string VersionFull {
            get {
                string ret = Version;
                if (VersionCodename.Length > 0) {
                    ret += " \"" + VersionCodename + "\"";
                }
                if ( VersionSuffix.Length > 0 ) {
                    ret += " " + VersionSuffix;
                }
                return ret;
            }
        }
        public static string VersionForCTCP {
            get {
                string ret = Version;
                if ( VersionCodename.Length > 0 ) {
                    ret += " \"" + VersionCodename + "\"";
                }
                return ret;
            }
        }

        static Random Random = new Random();

        public static int RandomNext(int max)
        {
            if ( max == 1 ) return 0;
            lock (Random) return Random.Next(max);
        }
        public static int RandomNext(int min, int max)
        {
            lock (Random) return Random.Next(min, max);
        }
    };
}
