using System;

namespace monochrome {

    public enum DCCMode {
        Send,
        TSend,
    };
    
    public struct DCCDescription {
        public DCCDescription(string nick, string filename, UInt16 port, DCCMode mode, String host = "") {
            Nick = nick; FileName = filename; Port = port; Mode = mode; Host = host;
        }
        public static bool Match(DCCDescription item1, DCCDescription item2) {
            return item1.Nick == item2.Nick && item1.FileName == item2.FileName;
        }
        /*
        public static bool Equals(DCCDescription item1, DCCDescription item2) {
            return StructHelper.MemberwiseEquals(item1,item2,typeof(DCCDescription));
        }
        public override bool Equals(object obj) {
            if (obj is DCCDescription) {
                return Equals(this,(DCCDescription)obj);
            } else {
                return false;
            }
        }
        public static bool operator==(DCCDescription item1, DCCDescription item2) {return Equals(item1,item2);}
        public static bool operator!=(DCCDescription item1, DCCDescription item2) {return !Equals(item1,item2);}
        */
        public string Nick;
        public string FileName;
        public UInt16 Port;
        public DCCMode Mode;
        public string Host;
    };

}
