﻿using System;
using System.Text.RegularExpressions;

namespace monochrome {

    internal class BSFilter {

        public static bool Test(string[] input) {
            string[] bsFilterTokens = PreferencesManager.Current.bsFilterTokens;
            if (bsFilterTokens.Length == 0) {
                return true;
            }
            for (int i = 0; i < input.Length; i++) {
                for (int j = 0; j < bsFilterTokens.Length; j++) {
                    if (Regex.IsMatch(input[i], BSFilter.WildcardToRegex(bsFilterTokens[j]))) {
                        return false;
                    }
                }
            }
            return true;
        }

        public static string WildcardToRegex(string pattern) {
            return "^" + Regex.Escape(pattern).Replace("\\*", ".*").Replace("\\?", ".") + "$";
        }
    }
}