﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;

namespace Monochrome_UWP {
    public sealed class VisibilityConverter : IValueConverter {
        object IValueConverter.Convert(object value, Type targetType, object parameter, string language) {
            var ret = Convert.ToBoolean(value) ? Visibility.Visible : Visibility.Collapsed;
            return ret;
        }
        object IValueConverter.ConvertBack(object value, Type targetType, object parameter, string language) {
            throw new NotImplementedException();
        }
    }

    public sealed class FontFamilyConverter : IValueConverter {
        object IValueConverter.Convert(object value, Type targetType, object parameter, string language) {
            try {
                return new FontFamily((string)value);
            } catch {
                return FontFamily.XamlAutoFontFamily;
            }
        }
        object IValueConverter.ConvertBack(object value, Type targetType, object parameter, string language) {
            throw new NotImplementedException();
        }
    }

    public sealed class BooleanNotConverter : IValueConverter {
        object IValueConverter.Convert(object value, Type targetType, object parameter, string language) {
            return !Convert.ToBoolean(value);
        }
        object IValueConverter.ConvertBack(object value, Type targetType, object parameter, string language) {
            throw new NotImplementedException();
        }
    }

}
