﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using monochrome;
using System.Threading.Tasks;

namespace Monochrome_UWP {
    public sealed partial class TriggerLog : Page {

        private ChannelViewHooks m_cvHooks;
        public ChannelViewHooks CV { get { return m_cvHooks; } }

        public TriggerLog() {
            this.InitializeComponent();
            this.Loaded += TriggerLog_Loaded;

            m_cvHooks = new Monochrome_UWP.ChannelViewHooks(ChannelView, ChannelViewScroll);
        }

        private void TriggerLog_Loaded(object sender, RoutedEventArgs e) {
            CV.ScrollToBottom();
        }

        protected override void OnNavigatedTo(NavigationEventArgs e) {
            base.OnNavigatedTo(e);
            State = (TriggerLogState) e.Parameter;
            State.Frontend = this;

            CV.Initialize(State.ViewContent);
        }
        protected override void OnNavigatedFrom(NavigationEventArgs e) {
            base.OnNavigatedFrom(e);
            if (State != null) {
                State.Frontend = null;
            }
            
        }
        public TriggerLogState State { get; set; }
    }

    public sealed class TriggerLogState : IDisposable {

        public TriggerLogState(MainPage p, string title) {
            m_ownerMainPage = new WeakReference<MainPage>(p);
            p.AddPage(title, typeof(TriggerLog), this);
            PreferencesManager.Notify += PreferencesManager_Notify;
        }
        void IDisposable.Dispose() {
            MainPage mp;
            if (m_ownerMainPage.TryGetTarget(out mp)) {
                mp.RemovePage(this);
                mp.TriggerLogClosed(this);
            }

            PreferencesManager.Notify -= PreferencesManager_Notify;
            PreferencesManager_Notify( PreferencesManager.Current );

        }

        private void PreferencesManager_Notify(PreferencesData newData) {
            m_lineCountLimit = newData.lineCountLimit;
            applyLineCountLimit();
        }

        public void AddLine(TextLine line) {
            ViewContent.AddLast(line);

            if (Frontend != null) {
                Frontend.CV.AddLine(line);
            }
            applyLineCountLimit();
        }
        private void applyLineCountLimit() {
            int limit = Math.Max(m_lineCountLimit, 10);

            if ((Int64)ViewContent.Count * 3 / 4 > limit) {
                int numGone = 0;
                while (ViewContent.Count > limit) { ViewContent.RemoveFirst(); ++numGone; }
                if (numGone > 0 && Frontend != null) Frontend.CV.RemoveFirstLines(numGone);
            }
        }

        private int m_lineCountLimit;

        private WeakReference<MainPage> m_ownerMainPage;

        public LinkedList<TextLine> ViewContent = new LinkedList<TextLine>();

        public TriggerLog Frontend { get; set; }
    }

}
