﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Input;

namespace Monochrome_UWP {
    public delegate void TextBoxKeyHook(object sender);

    public class TextBoxKeyHooks : TextBox {

        public event TextBoxKeyHook EnterPressed;
        public event TextBoxKeyHook EscPressed;
        public event TextBoxKeyHook HeightWillGrow;

        protected override void OnKeyDown(KeyRoutedEventArgs e) {
            if ( e.Key == Windows.System.VirtualKey.Escape && EscPressed != null ) {
                EscPressed(this);
                e.Handled = true;
                return;
            }
            if (e.Key == Windows.System.VirtualKey.Enter && EnterPressed != null) {
                var ctrl = Window.Current.CoreWindow.GetKeyState(Windows.System.VirtualKey.Control);
                if (!ctrl.HasFlag(Windows.UI.Core.CoreVirtualKeyStates.Down)) {
                    EnterPressed(this);
                    e.Handled = true;
                    return;
                }
            }
            if (e.Key == Windows.System.VirtualKey.Enter && HeightWillGrow != null) {
                HeightWillGrow(this);
            }
            base.OnKeyDown(e);
        }
    };
}
