﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.Storage.Pickers;
using monochrome;

namespace Monochrome_UWP {


    public class ServerWindowState : IRCWindowState, IServerConnectionDelegate, IDisposable {

        public ServerWindowState(MainPage _main, ServerParams _params, string _netName) : base(_main, _netName) {
            base.Connection = m_connection = new ServerConnection(this, this, _params, _netName);
            m_connection.PreopenChannels();
        }

        // IDisposable
        public override void Dispose() {
            base.Dispose();
            m_connection.Dispose();
        }

        public override void RunCommand(string command) {
            m_connection.runCommandAliasable(command, this);
        }

        // IServerConnectionDelegate
        void IServerConnectionDelegate.OnActivity() {

        }
        IMessageWindow IServerConnectionDelegate.NewQueryWindow(string forUser) {
            return new QueryWindowState(this, forUser);
        }
        IChannelWindow IServerConnectionDelegate.NewChannelWindow(string forChannel, ChannelStatus status) {
            return new ChannelWindowState(this, status);
        }
        bool IServerConnectionDelegate.SwitchToWindowIndex(int index) {
            return OwnerMainPage.SwitchToPageIndex( index );
        }
        void IServerConnectionDelegate.SwitchToWindowDelta(int delta) {
            if (delta == 0) return;
            OwnerMainPage.SwitchPageDelta(delta);

        }
        void IServerConnectionDelegate.MoveWindowDelta(IMessageWindow window, int delta) {
            // FIX ME
        }
        bool IServerConnectionDelegate.MoveWindowTo(IMessageWindow window, int index) {
            return false; // FIX ME
        }
        bool IServerConnectionDelegate.CanExternalUpdatePreferences() {
            return ! OwnerMainPage.PreferencesVisible;
        }
        void IServerConnectionDelegate.ExternalUpdatePreferences(PreferencesData prefs) {
            if (! OwnerMainPage.PreferencesVisible ) {
                PreferencesManager.Set( prefs );
            }
        }
        void IServerConnectionDelegate.LogActivity(string context, TextLine line, int level) {
            OwnerMainPage.LogActivity( this.Context, context, line, level );
        }
        async void IServerConnectionDelegate.OpenFileForDCCSend(Action<object, string> callMe, IMessageWindow context) {
            try {
                var picker = new FileOpenPicker();
                picker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
                picker.FileTypeFilter.Add("*");
                var result = await picker.PickMultipleFilesAsync();
                foreach ( var file in result ) {
                    callMe( file, file.Name );
                }
            } catch(Exception e) {
                context.PrintOutputV2( TextLine.Simple( e.Message ) );
            }
        }
        void IServerConnectionDelegate.BeginDCCSend(object pathObj, DCCDescription desc) {
            new DCCSendStatus( (Windows.Storage.StorageFile) pathObj, OwnerMainPage, m_connection, desc);
        }
        void IServerConnectionDelegate.BeginDCCReceive(DCCDescription desc, UInt64 _fileSize, PreferencesData _prefs, bool _autoAcceptTrigger) {
            new DCCReceiveState( OwnerMainPage, m_connection, desc, _fileSize, _prefs, _autoAcceptTrigger );
        }
        void IServerConnectionDelegate.OnManualAway(bool isAway) {
            OwnerMainPage.ManualAway = isAway;
        }
        public new ServerConnection Connection {
            get { return m_connection; }
        }

        private ServerConnection m_connection;
    }
}
