﻿using System;
using System.Collections.Generic;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;
using monochrome;
using System.ComponentModel;
using Windows.UI.Popups;

namespace Monochrome_UWP {

    public sealed partial class ServerSetup : Page, INotifyPropertyChanged {

        public event PropertyChangedEventHandler PropertyChanged;
        void NotifyPropertyChanged(String propertyName = "") {
            if (PropertyChanged != null) {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        public ServerSetup() {
            this.InitializeComponent();
        }
        protected override void OnNavigatedTo(NavigationEventArgs e) {
            base.OnNavigatedTo(e);
            State = (ServerSetupState) e.Parameter;
        }
        protected override void OnNavigatedFrom(NavigationEventArgs e) {
            base.OnNavigatedFrom(e);
            State.Save();
        }
        public ServerSetupState State { get; set; }

        private void OnConnect(object sender, RoutedEventArgs e) {
            State.Connect();
        }
        private void OnSave(object sender, RoutedEventArgs e) {
            State.Save();
        }

        private void OnShowNetworkList(object sender, RoutedEventArgs e) {
            this.NetworkListFlyout.ShowAt( (FrameworkElement) sender );
        }

        private void NetworkList_SelectionChanged(object sender, SelectionChangedEventArgs e) {
            var what = this.NetworkList.SelectedValue;
            this.NetworkListFlyout.Hide();
            State.NetName = (string) what;
        }
        public string[] NetworkListSource {
            get {
                var list = ServerConfigManager.ServerNames();
                var ret = new string[list.Count];
                list.CopyTo(ret,0);
                return ret;
            }
        }

        private void DeletePreset(object sender, RoutedEventArgs e) {
            string deleteThis;
            try {
                deleteThis = (string)((FrameworkElement)sender).DataContext;
            } catch {
                return;
            }
            var foo = new LinkedList<string>();
            foo.AddLast( deleteThis );
            ServerConfigManager.RemovePresets( foo );
            NotifyPropertyChanged("NetworkListSource");
        }
    }

    public sealed class ServerSetupState : INotifyPropertyChanged, IDisposable {

        public event PropertyChangedEventHandler PropertyChanged;
        void NotifyPropertyChanged(String propertyName = "") {
            if (PropertyChanged != null) {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        ServerParams m_params;
        public ServerParams Params { get { return m_params; } }

        public ServerSetupState(MainPage _main) {
            m_mainPage = new WeakReference<MainPage>(_main);

            m_params = ServerParams.Defaults;
            NetName = ServerConfigManager.DefaultServer();

            _main.AddPage( "Connect" , typeof(ServerSetup), this );

            Application.Current.EnteredBackground += App_EnterBackground;
        }
        public void Dispose() {
            MainPage mp;
            if ( m_mainPage.TryGetTarget( out mp ) ) {
                mp.RemovePage( this );
            }
            Application.Current.EnteredBackground -= App_EnterBackground;
        }
        private void App_EnterBackground(object sender, Windows.ApplicationModel.EnteredBackgroundEventArgs e) {
            Save();
        }

        bool ReloadPreset() {
            try {
                m_params = ServerConfigManager.GrabServerParamsByName(NetName);

                NotifyPropertyChanged("");
                return true;
            } catch { return false; }
        }


        public MainPage OwnerMainPage {
            get {
                MainPage mp;
                if (m_mainPage.TryGetTarget(out mp)) return mp;
                return null;
            }
        }

        public void Save() {
            ServerConfigManager.StoreServerParamsByName(NetName, Params);
        }

        public void Connect() {

            ServerConfigManager.StoreServerParamsByName( NetName, Params );
            ServerConfigManager.SetDefaultServer( NetName );

            Owner.Connect(Params, NetName );
        }

        public MainPage Owner {
            get {
                MainPage p;
                if (!m_mainPage.TryGetTarget(out p)) throw new InvalidOperationException();
                return p;
            }
        }
        private WeakReference<MainPage> m_mainPage;

        private string m_netName;
        public string NetName {
            get {
                return m_netName;
            }
            set {
                if ( m_netName != value ) {
                    m_netName = value;
                    if (!ReloadPreset()) NotifyPropertyChanged("NetName");
                }
            }
        }
        public string ParamHostName {
            get { return m_params.hostName; }
            set { m_params.hostName = value;}
        }
        public int ParamHostPort {
            get { return m_params.hostPort; }
            set { m_params.hostPort = value; }
        }
        public string ParamCharEncoding {
            get { return m_params.charEncodingName; }
            set { m_params.charEncodingName = value; }
        }
        public string ParamNicks {
            get { return m_params.nicks; }
            set { m_params.nicks = value; }
        }
        public string ParamNickPassword {
            get { return m_params.nickPassword; }
            set { m_params.nickPassword = value; }
        }
        public string ParamNickAccount {
            get { return m_params.nickAccount; }
            set { m_params.nickAccount = value; }
        }
        public string ParamAutoJoinChannels {
            get { return m_params.autoJoinChannels; }
            set { m_params.autoJoinChannels = value; }
        }
        public string ParamUserModes {
            get { return m_params.userModes; }
            set { m_params.userModes = value; }
        }
        public bool ParamAutoConnect {
            get { return m_params.autoConnect; }
            set { m_params.autoConnect = value; }
        }
        public string ParamServerPassword {
            get { return m_params.serverPassword; }
            set { m_params.serverPassword = value; }
        }
        public bool ParamSSL {
            get { return m_params.useSSL; }
            set { m_params.useSSL = value; }
        }
        public int ParamAllowRandomNickIndex {
            get {
                return ParamAllowRandomNick ? 1 : 0;
            }
            set {
                ParamAllowRandomNick = value > 0;
            }
        }
        public bool ParamAllowRandomNick {
            get { return m_params.allowRandomNick; }
            set { m_params.allowRandomNick = value; }
        }
        public string ParamInviteHandlers {
            get { return m_params.inviteHandlers; }
            set { m_params.inviteHandlers = value; }
        }

        public PopupMenu ContextMenu {
            get {
                return null; /*
                var menu = new PopupMenu();
                menu.Commands.Add(new UICommand("Close", (IUICommand) => { this.Dispose(); }));
                return menu; */
            }
        }
    }
}
