﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using monochrome;
using IRCUtils;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml;

namespace Monochrome_UWP {
    class QueryWindowState : IRCWindowState {
        public QueryWindowState(ServerWindowState _serv, string _user) : base(_serv.OwnerMainPage, _user) {
            Connection = _serv.Connection;
        }
        public override void Dispose() {
            Connection.WindowClosed(Context, this);
            base.Dispose();
        }
        public override void RunCommand(string command) {
            Connection.runContextCommandAliasable(Context, command, this);
        }
        // IMessageWindow method
        public override void HandleNickChange(string oldNick, string newNick, bool clash) {
            if (Nicks.Equals(oldNick, Context)) {
                Context = newNick;
            }
        }
    }
}