﻿using monochrome;
using System;
using System.ComponentModel;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Media;

namespace Monochrome_UWP {
    public class PreferencesForXAML : IDisposable, INotifyPropertyChanged {

        private static WeakReference<PreferencesForXAML> g_ref;

        public static PreferencesForXAML Instance {
            get {
                PreferencesForXAML obj;
                if (!g_ref.TryGetTarget(out obj)) throw new InvalidOperationException();
                return obj;
            }
        }


        public event PropertyChangedEventHandler PropertyChanged;
        public void NotifyPropertyChanged(String propertyName = "") {
            if (PropertyChanged != null) {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }


        public PreferencesForXAML() {
            g_ref = new WeakReference<PreferencesForXAML>(this);
            monochrome.PreferencesManager.Notify += PreferencesManager_Notify;
            Fetch(monochrome.PreferencesManager.Current);
        }


        public FontFamily FontFamily {
            get { return m_fontFamily; }
        }
        public FontFamily FontFamilyLists {
            get { return m_fontFamilyLists; }
        }
        public Brush BrushColorText {
            get { return m_brushColorText; }
        }
        public Brush BrushColorBackground {
            get { return m_brushColorBackground; }
        }
        public ElementTheme Theme {
            get { return m_theme; }
        }
        private FontFamily m_fontFamily, m_fontFamilyLists;
        private SolidColorBrush m_brushColorText, m_brushColorBackground;
        private ElementTheme m_theme;

        private void Fetch(monochrome.PreferencesData newData) {
            m_brushColorText = new SolidColorBrush(newData.ColorText);
            m_brushColorBackground = new SolidColorBrush(newData.ColorBackground);
            m_fontFamily = newData.FontFamily;
            m_fontFamilyLists = newData.FontFamilyLists;
            m_theme = newData.UseDarkTheme ? ElementTheme.Dark : ElementTheme.Light;
        }

        private void PreferencesManager_Notify(monochrome.PreferencesData newData) {
            Fetch(newData);
            NotifyPropertyChanged("");
        }

        void IDisposable.Dispose() {
            monochrome.PreferencesManager.Notify -= PreferencesManager_Notify;
            if (g_ref != null) {
                PreferencesForXAML foo;
                if (g_ref.TryGetTarget(out foo)) {
                    if (foo == this) {
                        g_ref = null;
                    }
                }
            }
        }
    }

}