﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using System.Threading.Tasks;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.Storage.Pickers;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using System.Threading;
using Windows.UI.Popups;

namespace Monochrome_UWP {

    public sealed partial class Preferences : Page {
        public Preferences() {
            this.InitializeComponent();
        }

        private CancellationTokenSource m_cancel = null;

        protected override void OnNavigatedTo(NavigationEventArgs e) {
            base.OnNavigatedTo(e);

            State = (PreferencesState) e.Parameter;

            m_cancel = new CancellationTokenSource();
            var stfu = TimerLoop(m_cancel.Token);
        }
        private async Task TimerLoop(CancellationToken cancel) {
            try {
                for( ;; ) {
                    await Task.Delay(TimeSpan.FromSeconds(1), cancel);
                    State.RefreshTimeFields();
                }
            } catch { }
        }

        protected override void OnNavigatedFrom(NavigationEventArgs e) {
            base.OnNavigatedFrom(e);
            State.Apply();
            m_cancel.Cancel();
        }

        public PreferencesState State { get; set; }

        private void OnPickLoggingFolder(object sender, RoutedEventArgs e) {
            State.PickLoggingFolder();
        }

        private bool m_pickFontLists;
        private void OnPickFont(object sender, RoutedEventArgs e) {
            m_pickFontLists = false;
            FontListFlyout.ShowAt((FrameworkElement) sender);
        }
        private void OnPickFontLists(object sender, RoutedEventArgs e) {
            m_pickFontLists = true;
            FontListFlyout.ShowAt((FrameworkElement)sender);
        }

        private void FontSelected(object sender, SelectionChangedEventArgs e) {
            var selected = (string) ((ListBox)sender).SelectedItem;
            FontListFlyout.Hide();
            if (m_pickFontLists) {
                State.FontNameLists = selected;
                State.NotifyPropertyChanged("FontNameLists");
            } else {
                State.FontName = selected;
                State.NotifyPropertyChanged("FontName");
            }
        }

        private void OnPickXferFolder(object sender, RoutedEventArgs e) {
            State.PickXferFolder();
        }
    }


    public sealed class PreferencesState : IDisposable, INotifyPropertyChanged {


        public event PropertyChangedEventHandler PropertyChanged;
        public void NotifyPropertyChanged(String propertyName = "") {
            if (PropertyChanged != null) {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        public PreferencesState(MainPage owner) {
            m_owner = new WeakReference<MainPage>(owner);
            owner.AddPage("Preferences", typeof(Preferences), this);

            Current = monochrome.PreferencesManager.Current;
            Application.Current.EnteredBackground += App_EnterBackground;
        }

        private void App_EnterBackground(object sender, Windows.ApplicationModel.EnteredBackgroundEventArgs e) {
            Apply();
        }

        public void Apply() {
            monochrome.PreferencesManager.Set(Current);
        }
        public void Dispose() {
            MainPage mp;
            if (m_owner.TryGetTarget(out mp)) mp.RemovePage(this);

            Application.Current.EnteredBackground -= App_EnterBackground;
        }


        public async void PickXferFolder() {
            try {
                FolderPicker picker = new FolderPicker();
                picker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
                picker.FileTypeFilter.Add(".STUPID");
                var folder = await picker.PickSingleFolderAsync();
                if (folder != null) {
                    var FAL = Windows.Storage.AccessCache.StorageApplicationPermissions.FutureAccessList;
                    if (Current.xferDefaultDirectoryToken != "" ) {
                        FAL.Remove(Current.xferDefaultDirectoryToken);
                    }
                    Current.xferDefaultDirectoryToken = FAL.Add(folder);
                    Current.xferDefaultDirectory = folder.Path;
                    NotifyPropertyChanged("XferDefaultDirectory");
                    Apply();
                }
            } catch(Exception e) {
                monochrome.Debug.WriteLine(e.Message);
            }
        }

        public async void PickLoggingFolder() {
            try {
                FolderPicker picker = new FolderPicker();
                picker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
                picker.FileTypeFilter.Add(".STUPID");
                var folder = await picker.PickSingleFolderAsync();
                if (folder != null) {

                    var FAL = Windows.Storage.AccessCache.StorageApplicationPermissions.FutureAccessList;
                    if (Current.loggingPathToken != "") {
                        FAL.Remove(Current.loggingPathToken);
                    }

                    Current.loggingPathToken = FAL.Add(folder);
                    Current.loggingPath = folder.Path;
                    NotifyPropertyChanged("LoggingFolder");
                    Apply();
                }
            } catch (Exception e) {
                monochrome.Debug.WriteLine(e.Message);
            }
        }

        private WeakReference<MainPage> m_owner;

        private monochrome.PreferencesData Current;

        public void RefreshTimeFields() {
            NotifyPropertyChanged("LoggingTimestampPreview");
            NotifyPropertyChanged("TimeStampFormatPreview");
        }

        public string UserFullName {
            get { return Current.fullName; }
            set { Current.fullName = value; }
        }
        public bool IdentEnabled {
            get { return Current.useIdent; }
            set { Current.useIdent = value; }
        }
        public string IdentUserName {
            get { return Current.identName; }
            set { Current.identName = value; }
        }
        public bool LoggingEnabled {
            get { return Current.useLogging; }
            set { Current.useLogging = value; }
        }
        public string LoggingTimestampFormat {
            get { return Current.loggingTimestampFormat; }
            set { Current.loggingTimestampFormat = value; NotifyPropertyChanged("LoggingTimestampPreview"); }
        }
        public bool LoggingSplitByDays {
            get { return Current.splitLogsByDays; }
            set { Current.splitLogsByDays = value; }
        }
        public string LoggingTimestampPreview {
            get {
                try {
                    return "Preview: " + DateTime.Now.ToString(this.LoggingTimestampFormat);
                } catch {
                    return "<invalid format>";
                }
                
            }
        }
        public string LoggingFolder {
            get { return Current.loggingPath; }
            set { Current.loggingPath = value; }
        }

        public bool ShowColors {
            get { return Current.displayColors; }
            set { Current.displayColors = value; }
        }
        public bool ShowFormatting {
            get { return Current.displayFormatting; }
            set { Current.displayFormatting = value; }
        }
        public bool ShowNickColors {
            get { return Current.useNickColors; }
            set { Current.useNickColors = value; }
        }
        public string TimeStampFormat {
            get { return Current.timestampFormat; }
            set { Current.timestampFormat = value; }
        }
        public string TimeStampFormatPreview {
            get {
                try {
                    return "Preview: " + DateTime.Now.ToString(this.TimeStampFormat);
                } catch {
                    return "<invalid format>";
                }
                
            }
        }
        public string FontName {
            get { return Current.fontName; }
            set { Current.fontName = value; }
        }
        public string FontNameLists {
            get { return Current.listFontName; }
            set { Current.listFontName = value; }
        }

        public string Aliases {
            get { return Current.aliases; }
            set { Current.aliases = value; }
        }
        public string DefaultQuitMessages {
            get { return Current.defaultQuitMessages; }
            set { Current.defaultQuitMessages = value; }
        }
        public string DefaultPartMessages {
            get { return Current.defaultPartMessages; }
            set { Current.defaultPartMessages = value; }
        }
        public string DefaultAwayMessages {
            get { return Current.defaultAwayMessages; }
            set { Current.defaultAwayMessages = value; }
        }
        public string DefaultKickMessages {
            get { return Current.defaultKickMessages; }
            set { Current.defaultKickMessages = value; }
        }

        public string Ignore {
            get { return Current.ignore; }
            set { Current.ignore = value; }
        }
        public string HalfIgnore {
            get { return Current.halfIgnore; }
            set { Current.halfIgnore = value; }
        }

        public string TriggerWords {
            get { return Current.triggerWords; }
            set { Current.triggerWords = value; }
        }
        public bool TriggerWordsCaseSensitive {
            get { return Current.triggerWordsCaseSensitive; }
            set { Current.triggerWordsCaseSensitive = value; }
        }
        public bool UseTriggerLog {
            get { return Current.useTriggerLog; }
            set { Current.useTriggerLog = value; }
        }
        public bool UseMessageLog {
            get { return Current.useMessageLog; }
            set { Current.useMessageLog = value; }
        }
        public int LineCountLimit {
            get { return Current.lineCountLimit; }
            set { Current.lineCountLimit = value; }
        }
        public int SplitLines {
            get { return Current.splitLines; }
            set { Current.splitLines = value; }
        }
        public bool AutoUnAway {
            get { return Current.unAwayOnActivity; }
            set { Current.unAwayOnActivity = value; }
        }
        public bool OutgoingMsgSecurity {
            get { return Current.outgoingMsgSecurity; }
            set { Current.outgoingMsgSecurity = value; }
        }
        public string HideMessageTypes {
            get { return Current.hideMessageTypes; }
            set { Current.hideMessageTypes = value; }
        }

        public string DCCPortRange {
            get { return Current.xferPortRange; }
            set { Current.xferPortRange = value; }
        }
        public bool DarkTheme {
            get {
                return Current.UseDarkTheme;
            }
            set {
                if ( value ) {
                    Current.colorBackground = monochrome.ColorDesc.FromARGB(0, 0, 0);
                    Current.colorText = monochrome.ColorDesc.FromARGB(255 ,255 ,255);
                } else {
                    Current.colorBackground = monochrome.ColorDesc.FromARGB(255, 255, 255);
                    Current.colorText = monochrome.ColorDesc.FromARGB(0, 0, 0);
                }
            }
        }

        public string XferDefaultDirectory {
            get { return Current.xferDefaultDirectory; }
        }
        public bool XferAskForLocation {
            get { return Current.xferAskForFileLocation; }
            set { Current.xferAskForFileLocation = value; }
        }
        public string XferAAUsers {
            get { return Current.xferAAUsers; }
            set { Current.xferAAUsers = value; }
        }
        public string XferAAChannels {
            get { return Current.xferAAChannels; }
            set { Current.xferAAChannels = value; }
        }

        public string[] FontNames { get; } = new string[] { "Arial", "Calibri", "Comic Sans MS", "Consolas", "Courier New", "Lucida Console", "Segoe UI", "Tahoma", "Verdana" };

        public int CurrentPageIndex {  get; set; }

        public PopupMenu ContextMenu {
            get {
                return null; /*
                var menu = new PopupMenu();
                menu.Commands.Add(new UICommand("Close", (IUICommand) => { this.Dispose(); }));
                return menu; */
            }
        }
    }

}
