﻿using System;
using Windows.UI;

namespace monochrome {

    class SystemColors {
        // Substitutes for WinForms API
        public static Color Window {
            get { return Colors.White; }
        }
        public static Color WindowText {
            get { return Colors.Black; }
        }
        public static Color GrayText {
            get { return Colors.Gray; }
        }
    };

    public partial struct PreferencesData {

        public Color ColorBackground {
            get { return colorBackground.IsEmpty ? SystemColors.Window : colorBackground.PlatformColor; }
        }
        public Color ColorText {
            get { return colorText.IsEmpty ? SystemColors.WindowText : colorText.PlatformColor; }
        }
        public Color AutoHighlightColor {
            get {
                var temp = ColorDesc.FromPlatformColor( ColorText );
                return (temp.Brightness < 0.5) ? Colors.DarkBlue : Colors.AliceBlue;
            }
        }
        public Color ColorHighlight {
            get { return colorHighlight.IsEmpty ? AutoHighlightColor : colorHighlight.PlatformColor; }
        }
        public Color ColorChanHighlight1 {
            get { return colorChanHighlight1.IsEmpty ? Colors.Blue : colorChanHighlight1.PlatformColor; }
        }
        public Color ColorChanHighlight2 {
            get { return colorChanHighlight2.IsEmpty ? Colors.Red : colorChanHighlight2.PlatformColor; }
        }
        public Color ColorChanHighlight3 {
            get { return colorChanHighlight3.IsEmpty ? Colors.OrangeRed : colorChanHighlight3.PlatformColor; }
        }
        public Color ColorUserJoin {
            get { return colorUserJoin.IsEmpty ? SystemColors.GrayText : colorUserJoin.PlatformColor; }
        }
        public Color ColorUserPart {
            get { return colorUserPart.IsEmpty ? SystemColors.GrayText : colorUserPart.PlatformColor; }
        }
    }
}
