﻿using System;
using System.IO;
using Windows.Storage.Streams;
using Windows.Storage;
using System.Runtime.InteropServices.WindowsRuntime;
using System.Xml;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.Threading;
using Windows.UI;
using Windows.UI.Xaml.Media;

namespace monochrome {
    class Debug {
        public static void WriteLine(string line) {
            System.Diagnostics.Debug.WriteLine(line);
        }
    };
    
    partial struct PreferencesData {
        public bool UseDarkTheme {
            get {
                return ! colorBackground.IsEmpty && colorBackground.IsDark;
            }
        }
        public FontFamily FontFamilyLists {
            get {
                if (this.listFontName.Length > 0) {
                    try {
                        return new FontFamily(this.listFontName);
                    } catch {
                    }
                }
                return FontFamily.XamlAutoFontFamily;
            }
        }
        public FontFamily FontFamily {
            get {
                if ( this.fontName.Length > 0 ) {
                    try {
                        return new FontFamily(this.fontName);
                    } catch {
                    }
                }
                return FontFamily.XamlAutoFontFamily;
            }
        }

        void SetPlatformDefaults() {
            this.fontName = FontFamily.XamlAutoFontFamily.Source;
            this.fontStyle = "";
            this.fontSize = "10";
            this.listFontName = this.fontName;
            this.listFontStyle = this.fontStyle;
            this.listFontSize = this.fontSize;
        }
    }

    static class PlatformMethods {
        public static byte[] StringMD5(string str) {
            var alg = Windows.Security.Cryptography.Core.HashAlgorithmProvider.OpenAlgorithm(Windows.Security.Cryptography.Core.HashAlgorithmNames.Md5);
            IBuffer buff = Windows.Security.Cryptography.CryptographicBuffer.ConvertStringToBinary(str, Windows.Security.Cryptography.BinaryStringEncoding.Utf8);
            return alg.HashData(buff).ToArray();
        }
    }

    static class PlatformExtensions {
        public static LinkedList<XmlNode> SelectNodes( this XmlNode parent, string name ) {
            LinkedList<XmlNode> ret = new LinkedList<XmlNode>();
            foreach (XmlNode child in parent.ChildNodes) {
                if (child.Name == name) ret.AddLast( child );
            }
            return ret;
        }
        public static XmlNode SelectSingleNode(this XmlNode parent, string name) {
            foreach (XmlNode child in parent.ChildNodes) {
                if (child.Name == name) return child;
            }
            return null;
        }
    }
    partial class PreferencesManager {
        public async static Task<StorageFile> FindConfigXML() {
            var localFolder = Windows.Storage.ApplicationData.Current.LocalFolder;
            return await localFolder.CreateFileAsync("MonochromeConfig.xml", Windows.Storage.CreationCollisionOption.OpenIfExists);
        }

        public static async Task<XmlDocument> GetPreferencesXMLAsync() {

            try {
                var file = await FindConfigXML();
                using (var stream = await file.OpenReadAsync()) {
                    XmlDocument doc = new XmlDocument();
                    await Task.Run( () => {
                        doc.Load(stream.AsStream());
                    } );
                    return doc;
                }
            } catch {
                return new XmlDocument();
            }

        }

        public static async Task SetPreferencesXMLAsync(XmlDocument doc) {
            var file = await FindConfigXML();
            using (var t = await file.OpenTransactedWriteAsync()) {
                t.Stream.Size = 0;
                await Task.Run( () => {
                    doc.Save(t.Stream.AsStreamForWrite());
                });

                await t.CommitAsync();
            }
        }

        public static void SetPreferencesXML(XmlDocument doc) {
            var t = Task.Run( () => {
                SetPreferencesXMLAsync(doc).Wait();
            } );
            t.Wait();
        }

        public static XmlDocument GetPreferencesXML() {
            XmlDocument ret = null;
            var t = Task.Run( () => {
                var inner = GetPreferencesXMLAsync();
                inner.Wait();
                ret = inner.Result;
            } );
            t.Wait();
            return ret;
        }
    }


    public partial struct ColorDesc {
        public static ColorDesc FromPlatformColor(Color c) {
            var d = new ColorDesc();
            d.PlatformColor = c;
            return d;
        }
        public Color PlatformColor {
            get {
                var c = new Color();
                c.R = Red8;
                c.G = Green8;
                c.B = Blue8;
                c.A = Alpha8;
                return c;
            }
            set {
                Red8 = value.R;
                Green8 = value.G;
                Blue8 = value.B;
                Alpha8 = value.A;
            }
        }
    }
}