﻿using System;
using System.Threading;
using System.Threading.Tasks;
using Windows.Networking;
using Windows.Networking.Sockets;


namespace monochrome {


    class IdentManager {
        
        private static CancellationTokenSource g_aborter = null;
        private static string g_name = "";


        private static async void handleSocket( StreamSocket s ) {
            try {
                var aborter = g_aborter.Token;
                using (var stream = new NetStreamText(System.Text.Encoding.ASCII, new NetStream(s))) {
                    var input = await stream.ReadLine(aborter);
                    var reply = /*"ERROR : NO-USER"*/ "USERID : UNIX : " + g_name;
                    reply = input + " : " + reply;
                    Debug.WriteLine("Replying ident: " + reply );
                    await stream.SendLine(reply, aborter);
                }
            } catch {
                // Debug.WriteLine("Ident failure: " + e.Message);
            }
        }
        private static async void WorkerV2( ) {
            try {
                var aborter = g_aborter.Token;
                using (StreamSocketListener listener = new StreamSocketListener()) {
                    listener.ConnectionReceived += (StreamSocketListener sender, StreamSocketListenerConnectionReceivedEventArgs args) => {
                        handleSocket(args.Socket);
                    };

                    await listener.BindServiceNameAsync("113");
                    
                    await Task.Delay(-1, aborter);
                }
            } catch {
                // Debug.WriteLine("Ident server exiting: " + e.Message);
            }
            if ( g_aborter != null ) {
                g_aborter.Dispose();
                g_aborter = null;
            }
        }

        public static void Bump(string name) {
            if ( name.Length == 0 ) name = IRCUtils.Nicks.Random();
            g_name = name;
            if (g_aborter == null) {
                g_aborter = new CancellationTokenSource();
                WorkerV2();
            }

            g_aborter.CancelAfter(TimeSpan.FromMinutes(1));
        }

        public static void Shutdown() {
            if ( g_aborter != null ) {
                g_aborter.Cancel();
            }
        }
    };
}
