﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Input;
using monochrome;

namespace Monochrome_UWP {

    class ACEditBoxUWP : IAutoCompleteEditBox {

        public ACEditBoxUWP(TextBox tb) {
            m_tb = new WeakReference<TextBox>(tb);
        }

        void IAutoCompleteEditBox.SetText(string newText, int newSelOffset) {
            var tb = TB;
            tb.Text = newText;
            tb.SelectionLength = 0;
            tb.SelectionStart = newSelOffset;
        }
        int IAutoCompleteEditBox.GetSelectionEnd() {
            var tb = TB;
            return tb.SelectionStart + tb.SelectionLength;
        }
        string IAutoCompleteEditBox.GetText() {
            return TB.Text;
        }

        TextBox TB {
            get {
                TextBox tb;
                if (!m_tb.TryGetTarget(out tb)) throw new InvalidOperationException();
                return tb;
            }
        }

        WeakReference<TextBox> m_tb;
    }

    public class IRCInputBox : TextBoxKeyHooks {

        private AutoCompleteHandler m_acHandler;

        public IAutoCompleteSource ACSource {
            set {
                m_acHandler.Reset( value );
            }
        }

        public IRCInputBox() {
            m_acHandler = new AutoCompleteHandler(null, new ACEditBoxUWP(this) );
            this.TextChanged += IRCInputBox_TextChanged;
            this.TextChanging += IRCInputBox_TextChanging;
        }

        private void IRCInputBox_TextChanging(TextBox sender, TextBoxTextChangingEventArgs args) {
            m_acHandler.OnTextChanging();
        }

        private void IRCInputBox_TextChanged(object sender, TextChangedEventArgs e) {
            
        }

        protected override void OnKeyDown(KeyRoutedEventArgs e) {
            if ( e.Key == Windows.System.VirtualKey.Tab ) {
                var shift = Window.Current.CoreWindow.GetKeyState(Windows.System.VirtualKey.Shift);

                m_acHandler.OnTriggerAutoComplete( shift.HasFlag(Windows.UI.Core.CoreVirtualKeyStates.Down) );
                e.Handled = true;
                return;
            }
            if (e.Key == Windows.System.VirtualKey.Up || e.Key == Windows.System.VirtualKey.Down) {
                var ctrl = Window.Current.CoreWindow.GetKeyState(Windows.System.VirtualKey.Control);
                if (ctrl.HasFlag(Windows.UI.Core.CoreVirtualKeyStates.Down)) {
                    HandleHistory( e.Key == Windows.System.VirtualKey.Down );
                    e.Handled = true;
                    return;
                }
            }
            base.OnKeyDown(e);
        }

        protected override void OnLostFocus(RoutedEventArgs e) {
            base.OnLostFocus(e);
            m_acHandler.OnEnterLeave();
        }
        protected override void OnGotFocus(RoutedEventArgs e) {
            base.OnGotFocus(e);
            m_acHandler.OnEnterLeave();
        }
        public void AddHistoryItem( ) {
            m_iterator = null;
            var text = this.Text;
            if ( text.Length == 0 ) return;
            var last = m_history.Last;
            if ( last != null && last.Value == text ) return;
            m_history.AddLast( text );
            while ( m_history.Count > 100 ) m_history.RemoveFirst();
        }
        private void HandleHistory( bool bDown ) {

            if ( m_iterator == null ) {
                var text = this.Text;
                if ( text.Length > 0 ) {
                    m_history.AddLast( text );
                    m_iterator = m_history.Last;
                }
            }

            LinkedListNode<string> iter = m_iterator;
            if (bDown) {
                if ( iter == null ) return;
                iter = iter.Next;
            } else {
                if ( iter == null ) iter = m_history.Last;
                else iter = iter.Previous;
                if ( iter == null ) return;
            }
            m_iterator = iter;
            this.Text = iter != null ? iter.Value : "";
        }
        private LinkedListNode<string> m_iterator = null;
        private LinkedList<string> m_history = new LinkedList<string>();
    };

}
