﻿using System;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;
using monochrome;
using Windows.Storage;
using Windows.Storage.Streams;
using System.Threading.Tasks;
using System.ComponentModel;

namespace Monochrome_UWP {
    public class FileReaderImpl : IDCCFileReader {
        public FileReaderImpl( IRandomAccessStream stream ) {
            m_stream = stream;
        }
        async Task IDCCFileReader.Seek(ulong position) {
            m_stream.Seek( position );
        }
        async Task<uint> IDCCFileReader.Read(byte[] buffer) {
            if (m_buffer == null || m_buffer.Capacity < buffer.Length ) {
                m_buffer = new Windows.Storage.Streams.Buffer( (uint) buffer.Length );
            }
            var result = await m_stream.ReadAsync( m_buffer, (uint) buffer.Length, InputStreamOptions.None );
            var len = result.Length;
            if ( len > 0 ) result.CopyTo(buffer);
            return len;
        }

        void IDisposable.Dispose() {
            m_stream.Dispose();
        }

        Windows.Storage.Streams.Buffer m_buffer;
        IRandomAccessStream m_stream;
    }
    public sealed partial class DCCSendWindow : Page {
        public DCCSendWindow() {
            this.InitializeComponent();
        }
        protected override void OnNavigatedTo(NavigationEventArgs e) {
            base.OnNavigatedTo(e);
            State = (DCCSendStatus) e.Parameter;
        }
        protected override void OnNavigatedFrom(NavigationEventArgs e) {
            base.OnNavigatedFrom(e);
        }

        public DCCSendStatus State { get; set; }

        private void ButtonResend(object sender, RoutedEventArgs e) {
            State.Resend();
        }
        private void ButtonClose(object sender, RoutedEventArgs e) {
            IDisposable v = State;
            v.Dispose();
        }
    }
    public sealed class DCCSendStatus : IDCCSendDelegate, IDisposable, INotifyPropertyChanged {

        public event PropertyChangedEventHandler PropertyChanged;
        public void NotifyPropertyChanged(String propertyName = "") {
            if (PropertyChanged != null) {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        StorageFile m_file;
        WeakReference<MainPage> m_ownerMainPage;
        DCCSend m_send;

        public DCCSendStatus( StorageFile f, MainPage ownerMainPage, ServerConnection connection, DCCDescription desc ) {
            m_file = f;

            m_ownerMainPage = new WeakReference<MainPage>(ownerMainPage);
            ownerMainPage.AddPage("Sending file", typeof(DCCSendWindow), this );

            UserName = desc.Nick;
            FileName = desc.FileName;
            Initialize(connection, desc);
        }
        async void Initialize(ServerConnection connection, DCCDescription desc) {
            var props = await m_file.GetBasicPropertiesAsync();
            FileSize = props.Size;
            NotifyPropertyChanged("FileSize");
            m_send = new monochrome.DCCSend( connection, desc, this, props.Size );
        }

        void IDisposable.Dispose() {
            MainPage mp;
            if ( m_ownerMainPage.TryGetTarget(out mp) ) {
                mp.RemovePage( this );
            }
            if ( m_send != null ) {
                m_send.Dispose();
                m_send = null;
            }
        }

        async Task<IDCCFileReader> IDCCSendDelegate.OpenFile() {
            var stream = await m_file.OpenReadAsync();
            return new FileReaderImpl( stream );
        }

        void IDCCSendDelegate.OnFinished(Exception e) {
            Running = false;
        }
        public string UserName { get; set; } = "";
        public string FileName { get; set; } = "";
        public UInt64 FileSize { get; set; } = 0;

        private string m_statusText = "", m_mainText = "";
        private UInt64 m_progress = 0;
        private UInt32 m_percentDone = 0;

        public string StatusText {
            get { return m_statusText; }
            set {
                if ( m_statusText != value ) {
                    m_statusText = value; NotifyPropertyChanged("StatusText");
                }
            }
        }
        public string MainText {
            get { return m_mainText; }
            set {
                if ( m_mainText != value ) {
                    m_mainText = value; NotifyPropertyChanged("MainText");
                }
            }
        }
        private bool m_running = false;
        public string CloseButtonText {
            get {
                return m_running ? "Cancel" : "Close";
            }
        }
        public bool Running {
            get {
                return m_running;
            }
            set {
                if ( value != m_running ) {
                    m_running = value;
                    NotifyPropertyChanged("Running");
                    NotifyPropertyChanged("CloseButtonText");
                }
            }
        }

        public UInt64 Progress { get { return m_progress; } }
        public UInt32 PercentDone { get { return m_percentDone; } }
        
        void IDCCSendDelegate.SetProgress(UInt64 bytesTransferred) {
            m_progress = bytesTransferred;
            if ( m_progress > FileSize ) m_progress = FileSize;
            NotifyPropertyChanged("Progress");
        }
        void IDCCSendDelegate.SetPercentDone(UInt32 percentDone) {
            m_percentDone = percentDone;
            NotifyPropertyChanged("PercentDone");
        }
        void IDCCSendDelegate.ToggleRunning(bool bRunning) {
            Running = bRunning;
        }
        public void Resend() {
            m_send.Resend();
        }
    }
}
