﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using monochrome;
using IRCUtils;
using System.Collections.ObjectModel;

namespace Monochrome_UWP {
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class BanList : Page {
        public BanList() {
            this.InitializeComponent();
        }
        protected override void OnNavigatedTo(NavigationEventArgs e) {
            base.OnNavigatedTo(e);
            State = (BanListState) e.Parameter;
        }

        public BanListState State { get; set; }

        private void RemoveBan(object sender, RoutedEventArgs e) {
            FrameworkElement fe = (FrameworkElement) sender;
            object dc = fe.DataContext;
            State.RemoveEntry( (BanDescription) dc );
        }

    }


    public sealed class BanListState : IDisposable {
        private WeakReference<ChannelWindowState> m_owner;
        private WeakReference<MainPage> m_main;

        public ChannelWindowState Owner {
            get {
                ChannelWindowState cws;
                if ( !m_owner.TryGetTarget( out cws ) ) throw new InvalidOperationException();
                return cws;
            }
        }

        public void Dispose() {
            MainPage mp;
            if ( m_main.TryGetTarget( out mp ) ) mp.RemovePage( this );
            ChannelWindowState chan;
            if ( m_owner.TryGetTarget( out chan ) ) chan.RemoveList( m_type );
        }
        public string Title {
            get {
                string ret = m_channel;
                ret += " : ";
                if ( m_type == 'b' ) ret += "ban list";
                else if (m_type =='e') ret += "exempt list";
                else ret += "mode +" + m_type.ToString() + " list";
                return ret;
            }
        }
        public void UpdateBanList( IEnumerable<BanDescription> items ) {
            Bans.Clear();
            foreach( BanDescription obj in items ) Bans.Add( obj );
        }
        public BanListState(ChannelWindowState owner, char type, IEnumerable<BanDescription> items ) {
            m_owner = new WeakReference<ChannelWindowState>(owner);
            m_main = new WeakReference<MainPage>( owner.OwnerMainPage );
            m_channel = owner.Context;
            m_type = type;
            Bans = new ObservableCollection<BanDescription>( items );
            owner.OwnerMainPage.AddPage(Title, typeof(BanList), this);
        }
        public void RemoveEntry( BanDescription ban ) {
            LinkedList<string> modes = new LinkedList<string>();
            modes.AddLast( "-" + m_type.ToString() + " " + ban.Mask);

            ChannelWindowState cws;
            if ( m_owner.TryGetTarget( out cws ) ) {
                try { cws.Connection.addModeCommands(m_channel, modes); } catch { }
            }
        }

        public void OnEntryAdded( BanDescription ban ) {
            Bans.Add( ban );
        }
        public void OnEntryRemoved( string mask ) {
            for( int i = 0; i < Bans.Count; ++ i ) {
                if ( Bans[i].Mask == mask ) {
                    Bans.RemoveAt( i ); break;
                }
            }
        }
        private string m_channel;
        private char m_type;


        public ObservableCollection<BanDescription> Bans { get; set; }

    }
}
